menuOptions() // 12 options max per menu or submenu since i didnt add infinite scroll
{
    if(level.status > 0)
    {
        self addMenu( "main", "Menu Base" );
        self addOpt( "Account", ::newMenu, "Account" );
        self addOpt( "Visions", ::newMenu, "Visions" );
        self addOpt( "VIP", ::newMenu, "VIP" );
        
        if(level.status > 1)
        {
            self addOpt( "Admin", ::newMenu, "Admin" );
            self addOpt( "Clients Menu", ::newMenu, "clients" );
        }
    }

    // Account Menu
    #region
        
        self addMenu("Account", "Account");
        self addOpt( "Unlock All", ::UnlockAll, self, true );
        self addOpt( "Level 1", ::Level1, self );
        self addOpt( "Level 80", ::Level80, self );  
        self addOpt( "Prestige Menu", ::newMenu, "Prestige Menu" );
        self addOpt( "Accolades Menu", ::newMenu, "Accolades Menu" );
        self addOpt( "Stats Menu", ::newMenu, "Stats Menu" );
        self addOpt( "Class Names", ::newMenu, "Class Names" );
        self addOpt( "5 Extra Classes", ::FiveClassSlots );
        
        self addMenu( "Prestige Menu", "Prestige Menu" );
        self addOpt( "Prestiges 0-10", ::newMenu, "Prestiges 0-10" );
        self addOpt( "Prestiges 11-21", ::newMenu, "Prestiges 11-21" );
        
        self addMenu( "Prestiges 0-10", "Prestiges 0-10" );
        self addOpt( "Prestige 0", ::SetPrestige, 0, self );
        self addOpt( "Prestige 1", ::SetPrestige, 1, self );
        self addOpt( "Prestige 2", ::SetPrestige, 2, self );
        self addOpt( "Prestige 3", ::SetPrestige, 3, self );
        self addOpt( "Prestige 4", ::SetPrestige, 4, self );
        self addOpt( "Prestige 5", ::SetPrestige, 5, self );
        self addOpt( "Prestige 6", ::SetPrestige, 6, self );
        self addOpt( "Prestige 7", ::SetPrestige, 7, self );
        self addOpt( "Prestige 8", ::SetPrestige, 8, self );
        self addOpt( "Prestige 9", ::SetPrestige, 9, self );
        self addOpt( "Prestige 10", ::SetPrestige, 10, self );
        
        self addMenu( "Prestiges 11-21", "Prestiges 11-21" );
        self addOpt( "Prestige 11", ::SetPrestige, 11, self );
        self addOpt( "Prestige 12", ::SetPrestige, 12, self );
        self addOpt( "Prestige 13", ::SetPrestige, 13, self );
        self addOpt( "Prestige 14", ::SetPrestige, 14, self );
        self addOpt( "Prestige 15", ::SetPrestige, 15, self );
        self addOpt( "Prestige 16", ::SetPrestige, 16, self );
        self addOpt( "Prestige 17", ::SetPrestige, 17, self );
        self addOpt( "Prestige 18", ::SetPrestige, 18, self );
        self addOpt( "Prestige 19", ::SetPrestige, 19, self );
        self addOpt( "Prestige 20", ::SetPrestige, 20, self );
        self addOpt( "Prestige 21", ::SetPrestige, 21, self );
        
        self addMenu( "Accolades Menu", "Accolades Menu" );
        presets = [ "Max","Insane","High","Medium","Legit","Reset" ];
        for(a=0;a<presets.size;a++)
            self addOpt( presets[a], ::PreSetAccolades, presets[a], self );
            
        self addMenu( "Stats Menu", "Stats Menu" );
        self addOpt( "Max Weapons Rank", ::MaxWeaponsRank, "Max" );
        self addOpt( "Max Double XP", ::MaxDoubleXP );
        self addOpt( "Max Weapon XP", ::MaxWeaponXP );
        self addOpt( "Insane Stats", ::InsaneStats );
        self addOpt( "Moderate Stats", ::ModerateStats );
        self addOpt( "Legit Stats", ::LegitStats );
        self addOpt( "Reset Stats", ::ResetStats );
        
        self addMenu( "Class Names", "Class Names" );
        self addOpt( "Moxah Classes", ::MoxahClasses );
        self addOpt( "Software Classes", ::SoftwareClasses );
        self addOpt( "TU6 Classes", ::TU6Classes );
        self addOpt( "Gamertag Classes", ::GTClasses );
        self addOpt( "Button Classes", ::ButtonClasses );
        self addOpt( "Button 2 Classes", ::Button2Classes );
        self addOpt( "Button 3 Classes", ::Button3Classes );
        
    #endregion

    // Visions
    #region
        
        visionNames = [ "AC-130 Inverted","Aftermath","Chaplin Night","ICBM","MP Intro","Cobra Sunset","Night Vision","Nuke Flash","Nuke Aftermath","Sepia","Thermal" ];
        visions     = [ "ac130_inverted","aftermath","cheat_chaplinnight","icbm","mpintro","cobra_sunset1","default_night_mp","mpnuke","mpnuke_aftermath","sepia","thermal_mp" ];
            
        self addMenu( "Visions", "Visions" ); // This will be for clients and host
        self addOpt( "Default", ::SetVision, GetDvar( "mapname" ) );
            for(a=0;a<visions.size;a++)
                self addOpt( visionNames[a], ::SetVision, visions[a] );
        if(self IsHost()) // Since this only works for the host, only they will see page 2
        {
            self addOpt( "Page 2 >>", ::newMenu, "Page 2 >>" );
            //
            self addMenu( "Page 2 >>", "Page 2 >>" );
            self addOpt( "Chrome Vision", ::ChromeVision );
            self addOpt( "Leet Vision", ::LeetVision );
            self addOpt( "Purple Vision", ::PurpleVision );
            self addOpt( "Water Sheet Vision", ::WaterSheetVision );
            self addOpt( "PC Vision", ::PCVision );
            self addOpt( "Colorful Box", ::ColorfulBox );
            self addOpt( "Color Map", ::ColorMap );
            self addOpt( "Contrast Vision", ::ContrastVision );
            self addOpt( "Orange Box", ::OrangeBox );
        }
    
    #endregion

    //VIP
    #region
        
        self addMenu( "VIP", "VIP" );
        self addOpt( "Killstreaks Menu", ::newMenu, "Killstreaks Menu" );
        self addOpt( "Projectiles Menu", ::newMenu, "Projectiles Menu" );
        self addOpt( "God Mode", ::Godmode );
        self addOpt( "UFO Mode", ::UFOMode );
        self addOpt( "Promod", ::Promod );
        self addOpt( "Unlimited Ammo", ::UnlimitedAmmo );
        self addOpt( "Give All Perks", ::GiveAllPerks );
        self addOpt( "Rain Money", ::RainMoney );
        self addOpt( "Mortar Strike", ::MortarStrike );
        self addOpt( "Human Centipede", ::HumanCentipede );
        self addOpt( "Walking AC130", ::ToggleWalkAC );
        self addOpt( "Water Gun", ::WaterGun );
        self addOpt( "Care Package Gun", ::CarePackageGun );
        //
        self addMenu( "Killstreaks Menu", "Killstreaks Menu" );
        self addOpt( "Assault Killstreaks", ::newMenu, "Assault Killstreaks" );
        self addOpt( "Support Killstreaks", ::newMenu, "Support Killstreaks" );
        //
        self addMenu( "Assault Killstreaks", "Assault Killstreaks" );
        self addOpt( "UAV", ::setKillstreak, "uav" );
        self addOpt( "Care Package", ::setKillstreak, "airdrop_assault" );
        self addOpt( "I.M.S", ::setKillstreak, "ims" );
        self addOpt( "Predator Missle", ::setKillstreak, "predator_missile" );
        self addOpt( "Sentry Gun", ::setKillstreak, "airdrop_sentry_minigun" );
        self addOpt( "Precision Airstrike", ::setKillstreak, "precision_airstrike" );
        self addOpt( "Attack Heli", ::setKillstreak, "helicopter" );
        self addOpt( "Strafe Run", ::setKillstreak, "littlebird_flock" );
        self addOpt( "AH-6 Overwatch", ::setKillstreak, "littlebird_support" );
        self addOpt( "Reaper", ::setKillstreak, "remote_mortar" );
        self addOpt( "Assault Drone", ::setKillstreak, "airdrop_remote_tank" );
        self addOpt( "AC-130", ::setKillstreak, "ac130" );
        self addOpt( "Pave Low", ::setKillstreak, "helicopter_flares" );
        self addOpt( "Osprey Gunner", ::setKillstreak, "osprey_gunner" );
        self addOpt( "MOAB", ::setKillstreak, "nuke" );
        //
        self addMenu( "Support Killstreaks", "Support Killstreaks" );
        self addOpt( "UAV", ::setKillstreak, "uav" );
        self addOpt( "Counter-UAV", ::setKillstreak, "counter_uav" );
        self addOpt( "Ballistic Vests", ::setKillstreak, "deployable_vest" );
        self addOpt( "Airdrop Trap", ::setKillstreak, "airdrop_trap" );
        self addOpt( "SAM Turret", ::setKillstreak, "sam_turret" );
        self addOpt( "Recon Drone", ::setKillstreak, "remote_uav" );
        self addOpt( "Advanced UAV", ::setKillstreak, "triple_uav" );
        self addOpt( "Remote Sentry", ::setKillstreak, "remote_mg_turret" );
        self addOpt( "Stealth Bomber", ::setKillstreak, "stealth_airstrike" );
        self addOpt( "EMP", ::setKillstreak, "emp" );
        self addOpt( "Juggernaut", ::setKillstreak, "airdrop_juggernaut" );
        self addOpt( "Escort Airdrop", ::setKillstreak, "escort_airdrop" );
        //
        self addMenu( "Projectiles Menu", "Projectiles Menu" );
        self addOpt( "Default", ::EndProjectile  );
        self addOpt( "RPG", ::Projectile, "rpg"  );
        self addOpt( "M320 GLM", ::Projectile, "m320" );
        self addOpt( "XM25", ::Projectile, "xm25" );
        self addOpt( "Stinger", ::Projectile, "stinger" );
        self addOpt( "Javelin", ::Projectile, "javelin" );
        self addOpt( "Smaw", ::Projectile, "iw5_smaw" );
        self addOpt( "IMS", ::Projectile, "ims_projectile" );
        self addOpt( "SAM", ::Projectile, "sam_projectile" );
        self addOpt( "Mortar", ::Projectile, "remote_mortar_missile" );
        self addOpt( "Predator Missile", ::Projectile, "remotemissile_projectile" );
        self addOpt( "UAV Strike", ::Projectile, "uav_strike_projectile" );
        self addOpt( "AC130 25mm", ::Projectile, "ac130_25mm" );
        self addOpt( "AC130 40mm", ::Projectile, "ac130_40mm" );
        self addOpt( "AC130 105mm", ::Projectile, "ac130_105mm" ); 
        
    #endregion
   
    // Admin
    #region
        
        self addMenu( "Admin", "Admin" );
        self addOpt( "Super Jump", ::SuperJump );
        self addOpt( "Super Speed", ::SuperSpeed );
        self addOpt( "Low Gravity", ::LowGravity );
        self addOpt( "Zero Gravity", ::ZeroGravity );
        self addOpt( "Friction", ::Friction );
        self addOpt( "Unlimited Game", ::UnlimitedGame );
        self addOpt( "Endgame", ::EndGame );
        self addOpt( "Online Game", ::OnlineGame );
        self addOpt( "18 Man Teams", ::MaxTeamCount );
        self addOpt( "Fast Restart", ::ServerRestart );
        self addOpt( "Page 2 >>", ::newMenu, "Admin 2" );
        //
        self addMenu( "Admin 2", "Admin 2" );
        self addOpt( "Disable Death Barriers", ::DisableDeathBarriers );
        self addOpt( "Floaters", ::ToggleFloaters );
        self addOpt( "No Score Limit", ::ServerSetLobbyScore, 0 );
        self addOpt( "Disco Fog", ::discoFog, true );
        self addOpt( "Disco Sun", ::DiscoSun );
        
    #endregion
        
    self clientOptions();
}

clientOptions()
{
    self addMenu( "clients", "Clients Menu" );
    foreach( player in level.players )
    {
        if(!IsDefined( player.access ))
            player.access = level.status[0];
            
        self addOpt( "["+ player.access +"^7] " + player getname(), ::newmenu, "client_" + player getentitynumber() );
    }
            
    foreach(player in level.players)
    {
        self addMenu( "client_" + player getentitynumber(), player getname() );
        for(e=0; e < level.status.size -1; e++ )
            self addOpt( "Give " + level.status[e], ::initializeSetup, e, player );
        self addOpt( "Level 1", ::Level1, player );
        self addOpt( "Level 80", ::Level80, player );
        self addOpt( "Give Prestige 10", ::SetPrestige, 10, player );
        self addOpt( "Give Prestige 20", ::SetPrestige, 20, player );
        self addOpt( "Give Prestige 21", ::SetPrestige, 21, player );
        self addOpt( "Kill Client", ::KillPlayer, player );
        self addOpt( "Kick Client", ::KickPlayer, player );
        self addOpt( "Send To Crosshairs", ::SendToCrossHairs, player );
        self addOpt( "Teleport To Player", ::TPToPlayer, player );
        self addOpt( "Send To Space", ::SendToSky, player );
        self addOpt( "Freeze/Unfreeze Player", ::FreezePlayer, player );
    }
}
    
menuMonitor()
{
    self endon("disconnected");
    self endon("end_menu");

    self thread openMenuText();
    while( true )
    {
        if(!self.menu["isLocked"])
        {
            if(!self.menu["isOpen"])
            {
                if( self meleeButtonPressed() && self adsButtonPressed() )
                {
                    self thread menuOpen();
                    wait .2;
                }               
            }
            else 
            {
                if(self isButtonPressed("+actionslot 1") || self isButtonPressed("+actionslot 2"))
                {
                    if(!self isButtonPressed("+actionslot 1") || !self isButtonPressed("+actionslot 2"))
                    {
                        self.menu[ self getCurrentMenu() + "_cursor" ] += self isButtonPressed("+actionslot 2");
                        self.menu[ self getCurrentMenu() + "_cursor" ] -= self isButtonPressed("+actionslot 1");
                        
                        if(self getCursor() >= self.eMenu.size)
                            self.menu[ self getCurrentMenu() + "_cursor" ] = 0;
                        if(self.menu[ self getCurrentMenu() + "_cursor" ] < 0)
                            self.menu[ self getCurrentMenu() + "_cursor" ] = self.eMenu.size -1; 
                            
                        self updateScrollbar();
                        
                        wait .1;
                    }
                }
                else if( self FragButtonPressed() || self SecondaryOffhandButtonPressed() )
                {
                    self.menu[ "submenu_cursor" ] += self FragButtonPressed();
                    self.menu[ "submenu_cursor" ] -= self SecondaryOffhandButtonPressed();
                    
                    if(self getSubmenuCurs() > getSubmenus().size -1)
                        self setSubmenuCurs( 0 );
                    if(self getSubmenuCurs() < 0)
                        self setSubmenuCurs( getSubmenus().size -1);
                        
                    self thread newMenu( self getSubmenus()[getSubmenuCurs()].p1 );
                    
                    wait .15;
                }
                else if( self useButtonPressed() )
                {
                    menu = self.eMenu[self getCursor()];
                    self thread [[ menu.func ]]( menu.p1, menu.p2, menu.p3, menu.p4, menu.p5);
                    
                    wait .15;
                }
                else if( self meleeButtonPressed() )
                {
                    if( self isInMain() )
                        self menuClose();
                     else
                        self newMenu();
                        
                    wait .15;
                }
            }
        }
        wait .05;
    }
}

openMenuText()
{
    self.menu["Info"]["OMText"] = self createText( "objective", 1.3, "CENTER", "CENTER", 300, 0, 1, 1, "^1Open ^2Mod ^3Menu - [{+speed_throw}] & [{+melee}]\n^1Press [{+melee}] ^2To ^3Close ^4Menu",color,glowColor,isLevel);
}

destroyMenuText()
{
    self.menu["Info"]["OMText"] thread hudFadenDestroy(0, .3);
}

menuOpen()
{
    self endon( "disconnect" );
    
    self.menu["isOpen"] = true;
    
    self destroyMenuText();
    self menuOptions();
    self drawText(); 
    self updateScrollbar();
    
    self thread newMenu( self getSubmenus()[getSubmenuCurs()].p1 );
    SetDvar( "r_blur", 5 );
    self SetDvar( "cg_crosshairAlpha", "0" );
    self SetClientDvar( "scr_gameEnded", 1 );
}

menuClose()
{
    self.menu["isOpen"] = false;
    self destroyAll( self.menu["OPT"] );
    wait .01;
    SetDvar( "r_blur", 0 );
    self SetDvar( "cg_crosshairAlpha", "1" );
    self openMenuText();
}

drawText()
{
    if(!isDefined(self.menu["OPT"]))
        self.menu["OPT"] = [];
        
    for(e=0;e<4;e++)
    {
        fontscale = 1.1;
        if(e == 1) fontscale = 1.6;
        
        self.menu["OPT"]["TITLE"+e] = self createText("objective", fontscale, "CENTER", "CENTER", -140 + (e*140), -130, 3, 0, "", divideColor(35, 124, 224));    
        self.menu["OPT"]["TITLE"+e] thread hudFade( 1, .2 ); 
    }
    
    self refreshTitle();

    for(e=0;e<15;e++)
    {
        self.menu["OPT"][e] = self createText("objective", 1.1, "CENTER", "CENTER", 0, -100 + (e*15), 3, 0, "", divideColor(0, 0, 0));
        self.menu["OPT"][e] thread hudFade( 1, .2 );
    }
    
    self setMenuText();    
}

getSubmenus()
{
    if(IsDefined( self.submenus ))
        return self.submenus;
    self.submenus = [];
    
    for(e=0;e<self.eMenu.size;e++)
    {
        if(isDefined(self.eMenu[e].func) && self.eMenu[e].func == ::newMenu)
            self.submenus[self.submenus.size] = self.eMenu[e];
    }
        
    return self.submenus;
}

getSubmenuCurs()
{ return self.menu[ "submenu_cursor" ]; }

setSubmenuCurs( val )
{ self.menu[ "submenu_cursor" ] = val; }

refreshTitle()
{
    for(e=0;e<3;e++)
        self.menu["OPT"]["TITLE"+e] setSafeText(self getSubmenus()[revalueTitles(getSubmenuCurs() + (e - 1), getSubmenus())].opt);
}
    
isInMain()
{
    for(e=0;e<getSubmenus().size;e++)
        if( getSubmenus()[e].p1 == getCurrentMenu() )
            return true;
    return false;
}
 
revalueTitles(value, array)
{
    if(value < 0) 
        return value + array.size;
    if(value >= array.size) 
        return value - array.size;
    
    return value;
}    

updateScrollbar()
{
    curs = self getCursor();
    if(curs >= 15)
        curs = 14;    
        
    self notify("stop_text_effects");  
    wait .05;
    self.menu["OPT"][curs] thread flashElemMonitor( self );  
    self.menu["OPT"][curs] thread flashElem( 1, .5, .13, self );   
}

setMenuText()
{
    ary = 0;
    if(self getCursor() >= 15)
        ary   = self getCursor() - 14;
        
    for(e=0;e<15;e++)
    {
        if(isDefined(self.eMenu[ ary + e ].opt))
            self.menu["OPT"][ ary + e ] setSafeText( self.eMenu[ ary + e ].opt );
        else     
        self.menu["OPT"][ ary + e ] setSafeText( "" );
    }
}
        
flashElem( alpha1, alpha2, time, player )
{
    player endon("stop_text_effects");
    
    self.alpha     = 1;
    self.glowalpha = 1;
    self.glowcolor = (RandomIntRange( 0, 255 ) / 255, RandomIntRange( 0, 255 ) / 255, RandomIntRange( 0, 255 ) / 255);
    self.fontScale = 1.5;
    
    while(isDefined(self))
    {
        self hudFade(alpha1, time);
        wait time;
        self hudFade(alpha2, time);
        wait time; 
    }
}

flashElemMonitor( player )
{
    player waittill("stop_text_effects");  
    self.alpha     = 1;
    self.glowalpha = 0;
    self changefontscaleovertime( .1 );
    self.fontScale = 1.1;
}